/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.ftp;

import com.quantumdata.ftp.CoFile;
import com.quantumdata.ftp.CoLoad;
import com.quantumdata.std.IQDConsole;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

final class CoDataLoad
extends CoLoad {
    private byte[] cbuf = new byte[4096];
    private InputStream ibuf = null;
    private OutputStream obuf = null;

    CoDataLoad(CoFile coFile, CoFile coFile2, IQDConsole iQDConsole) throws IOException {
        this.console = iQDConsole;
        try {
            this.ibuf = new BufferedInputStream(coFile2.getInputStream());
            this.obuf = new BufferedOutputStream(coFile.getOutputStream());
        }
        catch (IOException iOException) {
            if (this.ibuf == null) {
                iQDConsole.println("< Can't obtain INPUT STREAM for '" + coFile2.getName() + "'! >");
            } else if (this.obuf == null) {
                iQDConsole.println("< Can't obtain OUTPUT STREAM for '" + coFile.getName() + "'! >");
            }
            iQDConsole.println("Error:" + iOException.getMessage());
            System.out.println("Error:" + iOException.getMessage());
            this.close();
            throw iOException;
        }
    }

    public int transfer() throws IOException {
        int n = this.ibuf.read(this.cbuf, 0, 4096);
        if (n > 0) {
            this.obuf.write(this.cbuf, 0, n);
        }
        return n;
    }

    public void close() throws IOException {
        IOException iOException = null;
        while (this.ibuf != null || this.obuf != null) {
            try {
                if (this.ibuf != null) {
                    InputStream inputStream = this.ibuf;
                    this.ibuf = null;
                    inputStream.close();
                }
                if (this.obuf == null) continue;
                OutputStream outputStream = this.obuf;
                this.obuf = null;
                outputStream.close();
            }
            catch (IOException iOException2) {
                iOException = iOException2;
            }
        }
        if (iOException != null) {
            throw iOException;
        }
    }
}

